function Exp2_Setup
%EXP2_SETUP Set up workspace variables for the ELE 635 Experiment 2

% Get parameter names and values from mask
mask_ws_vars = get_param([gcs '/Model Parameters'],'maskwsvariables');

if ~isempty(mask_ws_vars)
    for i = 1:length(mask_ws_vars),
        curr_var = mask_ws_vars(i).Name;
        evalin('base',[curr_var ' = ' num2str(mask_ws_vars(i).Value) ';']);
    end      
else
    % add this part so that the model can be executed from MATLAB command
    % line
    evalin('base','Fs = 48000;');
    evalin('base','B  = 2000;');
    evalin('base','Fc = 10000;');
    evalin('base','fs = Fs;');
    evalin('base','ts = 1/Fs;');
end    
